package org.ksoap;

import org.kxml.*;

/** This class provides various soap properties relevant for
    (de)serialization, including a hook for defining mappings 
    between java classes and XML element names in subclasses
    of this class. */


public class SoapProperties {

    public boolean implicitTypes;
    public PrefixMap prefixMap;
    public String xsiNamespace;
    public String xsdNamespace;

    public SoapProperties () {
	this (false);
    }

    SoapProperties (boolean legacy) {
	if (legacy) {
	    xsiNamespace = Soap.XSI1999;
	    xsdNamespace = Soap.XSD1999;
	    prefixMap = Soap.prefixMap1999;
	}
	else {
	    xsiNamespace = Soap.XSI;
	    xsdNamespace = Soap.XSD;
	    prefixMap = Soap.prefixMap;
	}
    }


    /** Returns a new instance of the class associated with the given
	namespace and name. By returning an instance instead of a
	class, the implementor is enabled to map different names to
	the same java class and to store the name in a field. 
	If no mapping is found, null is returned. 	

        <p>Please note that the interface may be changed slightly
        for differential SOAP. */


    Object newInstance (String namespace, String name, String Id) {
	return null;
    }

    
    /** Returns the namespace/name pair (namespace/name/id triple) for
	the given java object in a string array. If not found, null is
	returned. */

    public String [] getName (Object object) {
	return null;
    }
}
    
	
